import maya.cmds as cmds
import random as rnd

#CREATION
#-------------------------------------------------------------------------------------
#create trunk
def createFractal(baseMesh, segments, childScale, spawnChance):

	if (baseMesh == "cube"):
		createCube = cmds.polyCube(ch=True)
	elif(baseMesh == "cylinder"):
		createCube = cmds.polyCylinder(ch=True, h=1.0, sa=10)

	#createCube = cmds.polyCube(ch=True)


	for i in range (segments):
		factor=childScale/100.0				#factor for scale
		pivotpos=factor**i/2 					#pivotpoint position
		cmds.rename('tree')

		if (i < 1):
			pivotpos=0.5
			cmds.rename('tree_base')
			tree_base = cmds.ls(sl=1)

		sel = cmds.ls(sl=1)
		cmds.duplicate(rc=True)
		newCube = cmds.ls(sl=1)
		cmds.parent (sel, newCube)

		cmds.xform(r=1, pivots=[0,pivotpos,0], s=[factor,factor,factor])
		cmds.xform(ro=[180,0,0])
		cmds.makeIdentity(apply=True, t=1, r=1, s=1, n=1, pn=1)
		cmds.xform(centerPivots=1)
	cmds.rename('tree_top')


	#create branches
	cmds.select('tree_base1')
	childs=cmds.listRelatives(cmds.ls(sl=True), ad=True, type='transform')
	childs.pop(0) #remove _top from list
	childs_reverse = sorted(childs, reverse=False)

	for number, object in enumerate(childs_reverse):
		cmds.duplicate(object, rc=True)
		cmds.parent(object, world=True)

	for number, object in enumerate(childs_reverse):
		random = rnd.randrange(0,360)
		s = rnd.uniform(0.5,0.8)
		cmds.xform(object, ro=[90,0,0], scale=[s, s, s], a=True) #set base rot

	for number, object in enumerate(childs_reverse):
		numObjs = len(childs)
		mother = 'tree'+str(number+1+numObjs)
		cmds.parent(object, mother) #make group again
		cmds.rename(object, ('%s%02d' % ('branch', number)))


	#spawn chance
	cmds.select('tree_base1')
	childs=cmds.listRelatives(cmds.ls(sl=True), ad=True, type='transform')
	cmds.select(childs)
	sel = cmds.ls( 'branch*', sl=True )
	counter = 0
	for number, object in enumerate(sel):
		random = rnd.randrange(0,100)
		if (random <spawnChance):
			counter=counter+1
		else:
			cmds.delete(object)
	print "branches created: ", counter, "/", segments-1;

	return;




#MODIFY
#-------------------------------------------------------------------------------------
#randomize BASE rotation
def baseRotation():
	cmds.select('tree_base1')
	childs=cmds.listRelatives(cmds.ls(sl=True), ad=True, type='transform')
	cmds.select(childs)
	sel = cmds.ls( 'branch*', sl=True )
	for number, object in enumerate(sel):
		random = rnd.randrange(0,360)
		cmds.xform(object, ro=[90,random,0])
	return;

#randomize BASE scale
def baseScale():
	cmds.select('tree_base1')
	childs=cmds.listRelatives(cmds.ls(sl=True), ad=True, type='transform')
	cmds.select(childs)
	sel = cmds.ls( 'branch*', sl=True )
	for number, object in enumerate(sel):
		s = rnd.uniform(0.5,0.8)
		cmds.xform(object, scale=[s, s, s])
	return;

#randomize SECONDARY rotation
def secondaryRotation():
	cmds.select('tree_base1')
	childs=cmds.listRelatives(cmds.ls(sl=True), ad=True, type='transform')
	cmds.select(childs)
	sel = cmds.ls( 'branch*', sl=True )                            #selects all branches
	childs=cmds.listRelatives(sel, ad=True, type='transform')      #childs = all branches + children

	for number, object in enumerate(childs):
		random = rnd.randrange(0,10)

		if (random > 7):
			cmds.xform(object, ro=[0,0,15])
		if (random < 3):
			cmds.xform(object, ro=[0,0,-15])
		if (random > 9):
			cmds.xform(object, ro=[0,0,-45])
	return;


#reset all branch rotation & scale
def resetRotation():
	#reset BASE rotation
	cmds.select('tree_base1')
	childs=cmds.listRelatives(cmds.ls(sl=True), ad=True, type='transform')
	cmds.select(childs)
	sel = cmds.ls( 'branch*', sl=True )
	for number, object in enumerate(sel):
		cmds.xform(object, ro=[90,0,0])

	#reset SECONDARY rotation
	cmds.select('tree_base1')
	childs=cmds.listRelatives(cmds.ls(sl=True), ad=True, type='transform')
	cmds.select(childs)
	sel = cmds.ls( 'branch*', sl=True )                            #selects all branches
	childs=cmds.listRelatives(sel, ad=True, type='transform')      #childs = all branches + children
	for number, object in enumerate(childs):
		cmds.xform(object, ro=[0,0,0])

	return;



#BUTTONS#
#-------------------------------------------------------------------------------------

def button_createTree():
	#get source values

	cube = cmds.radioButton("radioButton_cube", sl=True, q=True)
	cylinder = cmds.radioButton("radioButton_cylinder", sl=True, q=True)
	segments = cmds.intSlider("slider_segments", v=True, q=True)
	childScale = cmds.intSlider("slider_childScale", v=True, q=True)
	spawnChance = cmds.intSlider("slider_spawnChance", v=True, q=True)

	if (cube > 0):
		baseMesh = "cube"
	elif (cylinder > 0):
		baseMesh = "cylinder"

	print "BUTTON Create Tree"
	print "------------------------"
	print "baseMesh = ", baseMesh
	print "segments = ", segments
	print "childScale = ", childScale
	print "spawnChance = ", spawnChance

	#create the fractal tree with this values
	createFractal(baseMesh, segments, childScale, spawnChance)

	#disable create tree button
	cmds.button("button_createTree", edit=True, enable=False, label="done")
	return [baseMesh, segments, childScale, spawnChance];


def button_baseRotation():
	baseRotation();
	return;

def button_baseScale():
	baseScale();
	return;

def button_secondaryRotation():
	secondaryRotation();
	return;


def button_reset():
	resetRotation();
	resetCurl();
	return;

def button_close():
	cmds.deleteUI("MainWindow")
	return;


#Curl Slider#
#-------------------------------------------------------------------------------------

def curl_slider():
	#get values
	curlVertical = cmds.intSlider("slider_vertical", v=True, q=True)
	curlHorizontal = cmds.intSlider("slider_horizontal", v=True, q=True)

	#rotate
	cmds.select('tree_base1')
	childs=cmds.listRelatives(cmds.ls(sl=True), ad=True, type='transform')
	cmds.select(childs)
	sel = cmds.ls( 'branch*', sl=True )
	childs=cmds.listRelatives(sel, ad=True, type='transform')
	cmds.xform(childs, ro=[curlVertical,0,curlHorizontal])

	#TextField number
	cmds.textField("textField_curl_vertical", edit=True ,tx=curlVertical)
	cmds.textField("textField_curl_horizontal", edit=True ,tx=curlHorizontal)
	return;

def resetCurl():
	#reset slider
	cmds.intSlider("slider_vertical", edit=True ,v=0)
	cmds.intSlider("slider_horizontal", edit=True ,v=0)
	curl_slider();

	#reset TextField number
	cmds.textField("textField_curl_vertical", edit=True ,tx="0")
	cmds.textField("textField_curl_horizontal", edit=True ,tx="0")
	return;



